<?php
/**
 +-------------------------------------------------------------------------+
 |                                                                         |
 +-------------------------------------------------------------------------+
 | Author: 独木舟博客 <dumuzhou.org>                          |
 | Author: dumuzhou <admin@dumuzhou.org>                              |
 +-------------------------------------------------------------------------+
*/
function generateRandomName($length = 6) {
    $characters = 'abcdefghijklmnopqrstuvwxyz';
    $name = '';
    for ($i = 0; $i < $length; $i++) {
        $name .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $name;
}

// 读取姓名列表 TXT 文件 没有就使用自带的
function getRandomFullName() {
    $lastNames = file_exists('lastnames.txt') ? array_map('trim', file('lastnames.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)) : array(
        'Smith','Johnson','Williams','Brown','Jones','Garcia','Miller','Davis','Rodriguez','Martinez',
        'Hernandez','Lopez','Gonzalez','Wilson','Anderson','Thomas','Taylor','Moore','Jackson','Martin',
        'Lee','Perez','Thompson','White','Harris','Sanchez','Clark','Ramirez','Lewis','Robinson',
        'Walker','Young','Allen','King','Wright','Scott','Torres','Nguyen','Hill','Flores',
        'Green','Adams','Nelson','Baker','Hall','Rivera','Campbell','Mitchell','Carter','Roberts'
    );
    $firstNames = file_exists('firstnames.txt') ? array_map('trim', file('firstnames.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)) : array(
        'James','Mary','Robert','Patricia','John','Jennifer','Michael','Linda','William','Elizabeth',
        'David','Barbara','Richard','Susan','Joseph','Jessica','Thomas','Sarah','Charles','Karen',
        'Christopher','Nancy','Daniel','Lisa','Matthew','Betty','Anthony','Margaret','Mark','Sandra',
        'Donald','Ashley','Steven','Kimberly','Paul','Emily','Andrew','Donna','Joshua','Michelle',
        'Kenneth','Dorothy','Kevin','Carol','Brian','Amanda','George','Melissa','Timothy','Deborah'
    );

    $first = $firstNames[array_rand($firstNames)];
    $last = $lastNames[array_rand($lastNames)];

    $month = str_pad(rand(1, 12), 2, '0', STR_PAD_LEFT);
    $day = str_pad(rand(1, 28), 2, '0', STR_PAD_LEFT);

    $name = $first . $last . $month . $day;
    $name = preg_replace('/[^a-zA-Z0-9]/', '', $name);
    $name = strtolower($name);
    return $name;
}

// 初始化变量
$accountList = '';
$apiList = '';
$domain = $_POST['domain'] ?? '';
$prefix = $_POST['prefix'] ?? '';
$password = $_POST['password'] ?? '';
$count = $_POST['count'] ?? 10;
$space = (isset($_POST['space']) && trim($_POST['space']) !== '') ? $_POST['space'] : '5';
$delimiter = $_POST['delimiter'] ?? '----';
$gen_api = isset($_POST['generate_api']);
$protocol = $_POST['protocol'] ?? 'https';
$use_realname = isset($_POST['use_realname']);

// ✅ 默认 IMAP 服务器为 127.0.0.1，可手动修改
$imap_ip = $_POST['imap_ip'] ?? '127.0.0.1';
$port = $_POST['port'] ?? 143;
$delete = isset($_POST['delete_option']) ? (int)$_POST['delete_option'] : 0;
$format = $_POST['format'] ?? 'html';
$limit = $_POST['limit'] ?? 5;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (trim($delimiter) === '') $delimiter = '----';

    for ($i = 1; $i <= intval($count); $i++) {
        // 用户名生成逻辑
        if ($use_realname) {
            $randomPrefix = getRandomFullName();
        } else {
            $randomSuffix = generateRandomName(4);
            if ($prefix) {
                $randomPrefix = $prefix . $randomSuffix;
            } else {
                $randomPrefix = generateRandomName(6);
                $month = str_pad(rand(1, 12), 2, '0', STR_PAD_LEFT);
                $day = str_pad(rand(1, 28), 2, '0', STR_PAD_LEFT);
                $randomPrefix .= $month . $day;
            }
        }

        $randomPrefix = preg_replace('/[^a-z0-9]/', '', strtolower($randomPrefix));
        $userEmail = $randomPrefix . '@' . $domain;
        $pass = $password ? $password : bin2hex(random_bytes(5));

        $line = "$randomPrefix|$userEmail|$pass|$space|GB";
        $accountList .= $line . "\n";

        // ✅ 生成 API 链接（不再转义邮箱的 @）
        if ($gen_api) {
            $imap_ip_used = $_POST['imap_ip'] ?? '127.0.0.1';
            $api_domain = rtrim($protocol . '://' . $domain, '/');
            $api = "$userEmail{$delimiter}$pass{$delimiter}{$api_domain}/api/controller.php?"
                 . "imap_ip=" . urlencode($imap_ip_used)
                 . "&port=" . urlencode($port)
                 . "&username=" . $userEmail
                 . "&password=" . urlencode($pass)
                 . "&delete=" . urlencode($delete)
                 . "&format=" . urlencode($format)
                 . "&limit=" . urlencode($limit);
            $apiList .= $api . "\n";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="zh">
<head>
    <meta charset="UTF-8">
    <title>邮箱用户生成器</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background-color: #f8f9fa; }
        h1, h2 { color: #343a40; }
        label { display: block; margin: 10px 0 5px; }
        input, textarea, button, select { width: 100%; padding: 10px; margin-bottom: 10px; box-sizing: border-box; }
        input, textarea, select { border: 1px solid #ced4da; border-radius: 5px; }
        button {
            background-color: #28a745; color: white;
            border: none; border-radius: 5px;
            padding: 10px 30px;
            display: block;
            margin: 20px auto 10px;
            font-size: 16px;
            cursor: pointer;
        }
        button:hover { background-color: #218838; }
        .styled-checkbox {
            display: inline-flex; align-items: center; font-weight: bold; font-size: 16px;
            cursor: pointer; position: relative; user-select: none; margin: 10px 0;
        }
        .styled-checkbox input { position: absolute; opacity: 0; cursor: pointer; }
        .styled-checkbox .checkmark {
            height: 20px; width: 20px; background-color: #ccc; border-radius: 4px; margin-right: 10px;
            transition: all 0.3s ease; position: relative;
        }
        .styled-checkbox:hover .checkmark { transform: scale(1.1); }
        .styled-checkbox input:checked ~ .checkmark { background-color: #28a745; }
        .styled-checkbox .checkmark::after {
            content: ""; position: absolute; display: none; left: 6px; top: 2px; width: 5px; height: 10px;
            border: solid white; border-width: 0 2px 2px 0; transform: rotate(45deg);
        }
        .styled-checkbox input:checked ~ .checkmark::after { display: block; }
        .api-settings { display: none; padding: 10px; background: #eef; border-radius: 5px; margin-bottom: 10px; }
    </style>
</head>
<body>

<h1>生成邮箱用户</h1>
<form method="post">
    <label>域名:
        <input type="text" name="domain" required placeholder="例如: ruihumail.com" value="<?php echo htmlspecialchars($domain); ?>">
    </label>

    <label>邮箱前缀:
        <input type="text" name="prefix" placeholder="可选，留空为随机前缀" value="<?php echo htmlspecialchars($prefix); ?>">
    </label>

    <label>密码:
        <input type="text" name="password" placeholder="填写表示固定，留空为随机密码" value="<?php echo htmlspecialchars($password); ?>">
    </label>

    <label>生成条数:
        <input type="number" name="count" min="1" value="<?php echo htmlspecialchars($count); ?>">
    </label>

    <label>分配空间容量 (GB):
        <input type="number" name="space" min="1" placeholder="默认 5GB" value="<?php echo htmlspecialchars($space); ?>">
    </label>

    <label class="styled-checkbox">
        <input type="checkbox" name="use_realname" id="use_realname" <?php if ($use_realname) echo 'checked'; ?>>
        <span class="checkmark"></span>
        使用真实姓名生成用户名
    </label>

    <label class="styled-checkbox">
        <input type="checkbox" name="generate_api" id="generate_api" <?php if ($gen_api) echo 'checked'; ?> onclick="toggleApiSettings()">
        <span class="checkmark"></span>
        生成 API 调用链接
    </label>

    <div class="api-settings" id="api-settings">
        <label>协议（API 域名用）:
            <select name="protocol">
                <option value="https" <?php if ($protocol === 'https') echo 'selected'; ?>>https</option>
                <option value="http" <?php if ($protocol === 'http') echo 'selected'; ?>>http</option>
            </select>
        </label>

        <label>IMAP 服务器地址:
            <input type="text" name="imap_ip" value="<?php echo htmlspecialchars($imap_ip); ?>" placeholder="默认 127.0.0.1">
        </label>

        <label>端口:
            <input type="number" name="port" value="<?php echo htmlspecialchars($port); ?>">
        </label>

        <label>是否删除邮件:
            <select name="delete_option">
                <option value="0" <?php if ($delete == 0) echo 'selected'; ?>>不删除</option>
                <option value="1" <?php if ($delete == 1) echo 'selected'; ?>>删除</option>
            </select>
        </label>

        <label>显示格式:
            <select name="format">
                <option value="html" <?php if ($format === 'html') echo 'selected'; ?>>HTML</option>
                <option value="txt" <?php if ($format === 'txt') echo 'selected'; ?>>纯文本</option>
            </select>
        </label>

        <label>读取邮件数量限制:
            <input type="number" name="limit" value="<?php echo htmlspecialchars($limit); ?>">
        </label>

        <label>自定义分隔符:
            <input type="text" name="delimiter" placeholder="例如: ----" value="<?php echo htmlspecialchars($delimiter); ?>">
        </label>
    </div>

    <button type="submit">生成</button>
</form>

<?php if ($accountList): ?>
    <h2>生成的账号信息: <span style="color: red; font-size: 14px;">（复制到宝塔邮局批量添加）</span></h2>
    <textarea rows="10" readonly><?php echo htmlspecialchars($accountList); ?></textarea>
<?php endif; ?>

<?php if ($apiList): ?>
    <h2>生成的 API 链接:</h2>
    <textarea rows="10" readonly><?php echo htmlspecialchars($apiList); ?></textarea>
<?php endif; ?>

<script>
function toggleApiSettings() {
    var checkbox = document.getElementById('generate_api');
    var settings = document.getElementById('api-settings');
    settings.style.display = checkbox.checked ? 'block' : 'none';
}
window.onload = function() {
    toggleApiSettings();
};
</script>

</body>
</html>
