<?php
/**
 +-------------------------------------------------------------------------+
 |                                                                         |
 +-------------------------------------------------------------------------+
 | Author: 独木舟博客 <dumuzhou.org>                          |
 | Author: dumuzhou <admin@dumuzhou.org>                              |
 +-------------------------------------------------------------------------+
*/
header("Content-Type: text/html; charset=utf-8");
set_time_limit(30); // 防止脚本超时

// =============================
// 工具函数
// =============================
function decode_mime_header($str) {
    $elements = imap_mime_header_decode($str);
    $decoded = '';
    foreach ($elements as $element) $decoded .= $element->text;
    return $decoded;
}
function extract_email_address($str) {
    preg_match('/<(.+?)>/', $str, $matches);
    return $matches[1] ?? $str;
}
function get_body($inbox, $email_number, $format) {
    $structure = imap_fetchstructure($inbox, $email_number);
    $body = '';

    if (!isset($structure->parts)) {
        $body = imap_body($inbox, $email_number);
    } else {
        foreach ($structure->parts as $part_index => $part) {
            $is_html = (isset($part->subtype) && strtolower($part->subtype) == 'html');
            $is_text = (isset($part->subtype) && strtolower($part->subtype) == 'plain');

            if (($format === 'html' && $is_html) || ($format === 'txt' && $is_text)) {
                $body = imap_fetchbody($inbox, $email_number, $part_index + 1);
                switch ($part->encoding) {
                    case 3: $body = base64_decode($body); break;
                    case 4: $body = quoted_printable_decode($body); break;
                }
                $body = mb_convert_encoding($body, 'UTF-8', 'auto');
                break;
            }
        }
    }
    return $body ?: '(无内容)';
}
// =============================
// 参数接收
// =============================
$imap_ip  = $_GET['imap_ip'] ?? '';
$port     = $_GET['port'] ?? '993';
$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$delete   = isset($_GET['delete']) ? (int)$_GET['delete'] : 0;
$format   = strtolower($_GET['format'] ?? 'txt');
$limit    = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;

// ✅ 自动修复 URL 被 # 截断导致密码不完整的问题
if (isset($_SERVER['REQUEST_URI'])) {
    if (preg_match('/password=([^&]+)/', $_SERVER['REQUEST_URI'], $match)) {
        $password = urldecode($match[1]);
    }
}

if (!$imap_ip || !$username || !$password) {
    die("❌ 参数不完整，请传入 imap_ip、username、password");
}

// =============================
// 自动选择 IMAP 模式
// =============================
$flags = ($port == 993) ? '/imap/ssl' : '/imap/notls';
$mailbox = '{' . $imap_ip . ':' . $port . $flags . '}INBOX';

// =============================
// 连接邮箱
// =============================
$inbox = @imap_open($mailbox, $username, $password);
if (!$inbox) {
    die("❌ 无法连接邮箱: " . imap_last_error());
}

// =============================
// 读取邮件
// =============================
$emails = imap_search($inbox, 'ALL');
if (!$emails) {
    echo "📭 没有找到邮件";
    imap_close($inbox);
    exit;
}

rsort($emails); // 最新在前
$emails = array_slice($emails, 0, $limit);
$index = 1;

foreach ($emails as $email_number) {
    $overview = imap_fetch_overview($inbox, $email_number, 0)[0];
    $subject  = decode_mime_header($overview->subject ?? '');
    $from_raw = decode_mime_header($overview->from ?? '');
    $to_raw   = decode_mime_header($overview->to ?? '');
    $from_email = extract_email_address($from_raw);
    $to_email   = extract_email_address($to_raw);
    $body = get_body($inbox, $email_number, $format);

    echo "<div style='border:1px solid #ddd;padding:10px;margin:10px;border-radius:8px;background:#fafafa;'>";
    echo "<b>编号：</b>{$index}<br>";
    echo "<b>主题：</b>{$subject}<br>";
    echo "<b>发件人：</b>{$from_email}<br>";
    echo "<b>收件人：</b>{$to_email}<br>";
    echo "<hr>";
    echo ($format === 'html') ? $body : nl2br(htmlspecialchars($body));
    echo "</div>";

    if ($delete === 1) imap_delete($inbox, $email_number);
    $index++;
}

if ($delete === 1) {
    imap_expunge($inbox);
}
imap_close($inbox);
?>
